package com.biz.crm.cps.business.activity.scan.sdk.dto;

import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 扫码活动分利入参dto
 *
 * @author sunx
 * @date 2022/3/9
 */
@Data
@ApiModel(value = "ScanActivityShareProfitDto", description = "扫码活动分利入参dto")
public class ScanActivityShareProfitDto {

  /** 码 */
  @ApiModelProperty("码")
  private String barCode;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /** 扫码活动编码 */
  @ApiModelProperty("扫码活动编码")
  private String actCode;

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 参与对象
   *
   * @see ScanActivityParticipateObjEnum
   */
  @ApiModelProperty("参与对象")
  private String participateObj;

  /** 用户业务编码 经销商编码 终端编码 导购编码 消费者编码 */
  @ApiModelProperty("用户业务编码")
  private String userCode;
}
