package com.biz.crm.cps.business.activity.scan.sdk.enums;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 扫码活动参与对象枚举
 *
 * <p>对应 ParticipatorTypeEnum 值
 *
 * <p>C("c", "经销商"), TERMINAL("terminal", "终端"), SHOPPER("shopper", "导购"), CUSTOMER("customer",
 * "消费者");
 *
 * @author sunx
 * @date 2022/2/21
 */
@Getter
@AllArgsConstructor
public enum ScanActivityParticipateObjEnum {
  /** 扫码活动参与对象枚举 */
  CUSTOMER("customer", "customer", "经销商", "1", "c"),
  TERMINAL("terminal", "terminal", "终端", "2", "terminal"),
  SHOPPER("shopper", "shopper", "导购", "3", "user_guide"),
  USER("user", "user", "消费者", "4", "consumer"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  /** 对应外部扫码的参与类型 */
  private String transformKey;

  /**
   * 根据transformKey获取枚举对象
   *
   * @param transformKey
   * @return
   */
  public static ScanActivityParticipateObjEnum findByTransformKey(String transformKey) {
    if (StringUtils.isBlank(transformKey)) {
      return null;
    }
    Optional<ScanActivityParticipateObjEnum> first =
        Stream.of(ScanActivityParticipateObjEnum.values())
            .filter(a -> a.transformKey.equals(transformKey))
            .findFirst();
    return first.orElse(null);
  }
}
