package com.biz.crm.cps.business.activity.scan.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 扫码活动物料类型枚举
 *
 * @author sunx
 * @date 2022/2/21
 */
@Getter
@AllArgsConstructor
public enum ScanActivityProductScopeTypeEnum {
  /** 扫码活动物料类型枚举 */
  PRODUCT_LEVEL("product_level", "product_level", "产品层级", "1"),
  MATERIAL_GROUP("material_group", "material_group", "物料组", "2"),
  MATERIAL("material", "material", "物料", "3"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
