package com.biz.crm.cps.business.activity.scan.sdk.enums;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 扫码活动奖励扫码类型枚举
 *
 * <p>BarCodeTypeEnum BOX("box", "1", "箱"), BOTTLE("bottle", "2", "盒"), COVER_CODE("coverCode", "3",
 * "盖内码");
 *
 * @author sunx
 * @date 2022/2/21
 */
@Getter
@AllArgsConstructor
public enum ScanActivityRewardScanTypeEnum {
  /** 扫码活动奖励扫码类型枚举 */
  BOX("box", "box", "箱码", "1", "box", "1"),
  PACK("pack", "pack", "盒码", "2", "bottle", "2"),
  LIB("lib", "lib", "盖内码", "3", "coverCode", "3"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
  /** 对应外部扫码的参与类型 */
  private String transformKey;
  /**
   * 码类型
   *
   * @see BarCodeTypeEnum flag
   */
  private String barCodeType;

  /**
   * 根据transformKey获取枚举对象
   *
   * @param transformKey
   * @return
   */
  public static ScanActivityRewardScanTypeEnum findByTransformKey(String transformKey) {
    if (StringUtils.isBlank(transformKey)) {
      return null;
    }
    Optional<ScanActivityRewardScanTypeEnum> first =
        Stream.of(ScanActivityRewardScanTypeEnum.values())
            .filter(a -> a.transformKey.equals(transformKey))
            .findFirst();
    return first.orElse(null);
  }

  /**
   * 根据barCodeType获取枚举对象
   *
   * @param barCodeType
   * @return
   */
  public static ScanActivityRewardScanTypeEnum findByBarCodeType(String barCodeType) {
    if (StringUtils.isBlank(barCodeType)) {
      return null;
    }
    Optional<ScanActivityRewardScanTypeEnum> first =
        Stream.of(ScanActivityRewardScanTypeEnum.values())
            .filter(a -> a.barCodeType.equals(barCodeType))
            .findFirst();
    return first.orElse(null);
  }
}
