package com.biz.crm.cps.business.activity.scan.sdk.enums;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 扫码活动奖励类型枚举
 *
 * <p>RewardMountRegister 奖励策略挂载观察 奖励发放 cost 费用 integral 积分 redpacket 红包
 *
 * @author sunx
 * @date 2022/2/21
 */
@Getter
@AllArgsConstructor
public enum ScanActivityRewardTypeEnum {
  /** 扫码活动奖励类型枚举 */
  RED_PACKET("red_packet", "red_packet", "红包", "1", "redpacket"),
  POINT("point", "point", "积分", "2", "integral"),
  FEE("fee", "fee", "费用", "3", "cost"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
  /** 对应外部扫码的参与类型 */
  private String transformKey;
  /**
   * 根据dictCode获取枚举对象
   *
   * @param dictCode
   * @return
   */
  public static ScanActivityRewardTypeEnum findByDictCode(String dictCode) {
    if (StringUtils.isBlank(dictCode)) {
      return null;
    }
    Optional<ScanActivityRewardTypeEnum> first =
        Stream.of(ScanActivityRewardTypeEnum.values())
            .filter(a -> a.dictCode.equals(dictCode))
            .findFirst();
    return first.orElse(null);
  }

  /**
   * 根据transformKey获取枚举对象
   *
   * @param transformKey
   * @return
   */
  public static ScanActivityRewardTypeEnum findByTransformKey(String transformKey) {
    if (StringUtils.isBlank(transformKey)) {
      return null;
    }
    Optional<ScanActivityRewardTypeEnum> first =
        Stream.of(ScanActivityRewardTypeEnum.values())
            .filter(a -> a.transformKey.equals(transformKey))
            .findFirst();
    return first.orElse(null);
  }
}
