package com.biz.crm.cps.business.activity.scan.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 扫码活动状态枚举
 *
 * @author sunx
 * @date 2022/2/21
 */
@Getter
@AllArgsConstructor
public enum ScanActivityStatusEnum {
  /** 扫码活动状态枚举 */
  DEFAULT("default", "default", "待开始", "1"),
  RUNNING("running", "running", "进行中", "2"),
  FINISH("finish", "finish", "已结束", "3"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
