package com.biz.crm.cps.business.activity.scan.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 扫码活动参与状态枚举
 *
 * @author sunx
 * @date 2022/3/28
 */
@Getter
@AllArgsConstructor
public enum ScanParticipateStatusEnum {
  /** 扫码活动参与状态枚举 */
  DEFAULT("default", "default", "待参与", "1"),
  PARTICIPATE("participate", "participate", "已参与", "2"),
  OVERDUE("overdue", "overdue", "已过期", "3"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
