package com.biz.crm.cps.business.activity.scan.sdk.register;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityParticipateScopeDto;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 参与范围注册器
 *
 * @author sunx
 * @date 2022/2/22
 */
public interface ScanActivityParticipateScopeRegister {

  /**
   * 维度系统编码，系统唯一，非常重要
   *
   * @return
   */
  String getType();

  /**
   * 维度中文描述,用于前端展示，非常重要
   *
   * @return
   */
  String getTypeDesc();

  /**
   * 显示排序
   *
   * @return
   */
  default int sort() {
    return -100;
  }

  /**
   * 根据配置获取关联的userCode集合
   *
   * @param participateScope all-全部,part-部分,special-指定
   * @param list
   * @return
   */
  Set<String> findScopeCodeSet(String participateScope, List<ScanActivityParticipateScopeDto> list);

  /**
   * 根据编码获取对应业务的详细信息
   *
   * @param userCodeSet
   * @return
   */
  Map<String, JSONObject> findDataMapByCodes(Set<String> userCodeSet);
}
