package com.biz.crm.cps.business.activity.scan.sdk.register;

import java.util.Set;

/**
 * 物料范围注册器接口
 *
 * @author sunx
 * @date 2022/2/22
 */
public interface ScanActivityProductScopeRegister {

  /**
   * 维度系统编码，系统唯一，非常重要
   *
   * @return
   */
  String getType();

  /**
   * 维度中文描述,用于前端展示，非常重要
   *
   * @return
   */
  String getTypeDesc();

  /**
   * 显示排序
   *
   * @return
   */
  default int sort() {
    return -100;
  }

  /**
   * 根据物料范围配置的关联业务编码集合获取包含的物料编码集合
   *
   * @param relateCodeSet
   * @return
   */
  Set<String> findByRelateCodeSet(Set<String> relateCodeSet);
}
