package com.biz.crm.cps.business.activity.scan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ParticipateActivityDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityListPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityListVo;
import org.springframework.data.domain.Pageable;

/**
 * 扫码活动前端分页列表接口
 *
 * @author sunx
 * @date 2022/3/28
 */
public interface ScanActivityListVoService {

  /**
   * 扫码活动分页
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<ScanActivityListVo> findByConditions(
      Pageable pageable, ScanActivityListPaginationDto paginationDto);

  /**
   * 参与活动
   *
   * @param dto
   */
  void participateActivity(ParticipateActivityDto dto);

  /**
   * 获取活动参与人数
   *
   * @param code
   * @return
   */
  String findParticipateNumsByCode(String code);
}
