package com.biz.crm.cps.business.activity.scan.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityParticipateScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityDictVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityParticipateScopeVo;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 扫码活动参与范围配置业务相关接口
 *
 * @author sunx
 * @date 2022/2/22
 */
public interface ScanActivityParticipateScopeVoService {

  /**
   * 获取扫码活动参与对象下拉
   *
   * @return
   */
  List<ScanActivityDictVo> findParticipateObjSelectList();

  /**
   * 保存参与范围配置信息
   *
   * @param actCode
   * @param participateScope
   * @param list
   */
  void createParticipateScope(
      String actCode, String participateScope, List<ScanActivityParticipateScopeDto> list);

  /**
   * 根据活动编码获取参与范围配置明细
   *
   * @param participateObj
   * @param actCode
   * @return
   */
  List<ScanActivityParticipateScopeVo> findByParticipateObjAndActCode(
      String participateObj, String actCode);

  /**
   * 根据配置获取关联的范围业务编码集合
   *
   * @param participateObj
   * @param participateScope
   * @param list
   * @return
   */
  Set<String> findScopeCodeSet(
      String participateObj, String participateScope, List<ScanActivityParticipateScopeDto> list);

  /**
   * 根据关联人员编码+参与对象获取对应人员的详细信息
   *
   * @param participateObj
   * @param userCodeSet
   * @return
   */
  Map<String, JSONObject> findDataMapByParticipateObjAndUserCodes(
      String participateObj, Set<String> userCodeSet);
}
