package com.biz.crm.cps.business.activity.scan.sdk.service;

import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityProductScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityDictVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityProductScopeVo;
import java.util.List;
import java.util.Set;

/**
 * 扫码活动物料配置接口
 *
 * @author sunx
 * @date 2022/2/21
 */
public interface ScanActivityProductScopeVoService {

  /**
   * 保存扫码活动物料配置信息
   *
   * @param list
   * @param actCode
   */
  void createProductScope(List<ScanActivityProductScopeDto> list, String actCode);

  /**
   * 根据活动编码获取活动物料配置信息
   *
   * @param actCode
   * @return
   */
  List<ScanActivityProductScopeVo> findByActCode(String actCode);

  /**
   * 根据物料范围配置信息获取物料编码信息
   *
   * @param list
   * @return
   */
  Set<String> findMaterialCodeSet(List<ScanActivityProductScopeDto> list);

  /**
   * 获取注册器实现的物料范围可选类型-需要单独排除单品的
   *
   * @return
   */
  List<ScanActivityDictVo> findProductScopeTypeList();
}
