package com.biz.crm.cps.business.activity.scan.sdk.service;

import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityRewardDto;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import java.util.List;

/**
 * 活动规则Vo service
 *
 * @author sunx
 * @date 2022/2/21
 */
public interface ScanActivityRewardVoService {

  /**
   * 保存扫码规则信息
   *
   * @param rewardList
   * @param actCode
   */
  void createReward(List<ScanActivityRewardDto> rewardList, String actCode);

  /**
   * 根据活动编码获取规则详情
   *
   * @param actCode
   * @return
   */
  List<ScanActivityRewardVo> findByActCode(String actCode);

  /**
   * 根据扫码入参信息获取通知信息
   *
   * @param dto
   * @param rewardList
   * @return
   */
  List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(
      ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardList);
}
