package com.biz.crm.cps.business.activity.scan.sdk.service;

import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityQueryDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityShareProfitDto;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityVo;
import java.util.List;
import java.util.Set;

/**
 * 扫码活动Vo接口
 *
 * @author sunx
 * @date 2022-02-16 16:40:07
 */
public interface ScanActivityVoService {

  /**
   * 根据活动id获取活动详情
   *
   * @param id
   * @return
   */
  ScanActivityVo findDetailById(String id);

  /**
   * 扫码活动主要信息，不包含参与范围，物料范围，规则，红包发放账户信息
   *
   * @param id
   * @return
   */
  ScanActivityVo findById(String id);

  /**
   * 新增活动
   *
   * @param dto
   * @return
   */
  ScanActivityVo create(ScanActivityDto dto);

  /**
   * 编辑活动
   *
   * @param dto
   * @return
   */
  ScanActivityVo update(ScanActivityDto dto);

  /**
   * 获取用户已参与且当前正在执行的扫码活动编码
   *
   * @param dto
   * @return
   */
  String findActCodeByScanActivityQueryDto(ScanActivityQueryDto dto);

  /**
   * 根据活动编码获取活动主信息
   *
   * @param actCodeSet
   */
  List<ScanActivityVo> findMainByActCodes(Set<String> actCodeSet);
}
