package com.biz.crm.cps.business.activity.scan.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 扫码活动前端列表Vo
 *
 * @author sunx
 * @date 2022-02-16 16:40:08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "扫码活动前端列表Vo")
public class ScanActivityListVo {

  /** 主键 */
  @ApiModelProperty("主键")
  private String id;

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  private String code;

  /** 活动名称 */
  @ApiModelProperty("活动名称")
  private String name;

  /** 活动开始时间 */
  @ApiModelProperty("活动开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date startTime;

  /** 活动结束时间 */
  @ApiModelProperty("活动结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date endTime;

  /** 参与对象 ScanActivityParticipateObjEnum */
  @ApiModelProperty("参与对象,customer-经销商,terminal-终端,shopper-导购,user-消费者")
  private String participateObj;

  /** 参与类型 ScanActivityParticipateTypeEnum */
  @ApiModelProperty("参与类型,manual-手动参与,automatic-自动参与")
  private String participateType;

  /** 参与开始时间 */
  @ApiModelProperty("参与开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date participateStartTime;

  /** 参与截止时间 */
  @ApiModelProperty("参与截止时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date participateEndTime;

  /** 创建时间 */
  @ApiModelProperty("创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /** 参与时间 */
  @ApiModelProperty("参与时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date participateTime;

  /** 参与范围 ScanActivityScopeEnum */
  @ApiModelProperty("参与范围,all-全部,part-部分,special-指定")
  private String participateScope;

  /** 物料范围 ScanActivityScopeEnum */
  @ApiModelProperty("物料范围,part-部分,special-指定")
  private String productScope;

  /** 活动参与状态 ScanParticipateStatusEnum */
  @ApiModelProperty("活动参与状态,default-待参与,participate-已参与,overdue-已过期")
  private String participateStatus;

  /** 活动描述 */
  @ApiModelProperty("活动描述")
  private String remark;
}
