package com.biz.crm.cps.business.activity.scan.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 可参与扫码活动物料范围明细vo
 *
 * @author sunx
 * @date 2022-02-16 16:40:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "可参与扫码活动物料范围明细vo")
public class ScanActivityProductScopeItemVo {

  /** 物料编码 */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /** 产品名称 */
  @ApiModelProperty("产品名称")
  private String materialName;

  /**
   * 物料类型
   *
   * <pre>
   * "big":"大"
   * "small", "小"
   * "bzsp": "标准商品"
   * "cx":"促销品"
   * "finished_product":"产成品"
   * "marketing_materials":"营销物料"
   * </pre>
   */
  @ApiModelProperty("物料类型")
  private String materialType;

  /** 产品层级编码 */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /** 产品层级 */
  @ApiModelProperty("产品层级")
  private String productLevelName;
}
