package com.biz.crm.cps.business.activity.scan.sdk.vo;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 扫码活动物料范围配置信息vo
 *
 * @author sunx
 * @date 2022-02-16 16:40:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "扫码活动物料范围配置信息Vo")
public class ScanActivityProductScopeVo {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  private String actCode;

  /** 范围类型 cps-product-level数据字典 */
  @ApiModelProperty("范围类型，cps-product-level数据字典")
  private String scopeType;

  /** 关联物料业务编码 */
  @ApiModelProperty("关联物料业务编码")
  private String relateCode;

  /** 关联业务描述 */
  @ApiModelProperty("关联业务描述")
  private String relateName;
  /** 排序 */
  @ApiModelProperty("排序")
  private Integer sort;

  /** 业务扩展信息（如果是物料，物料的扩展信息） */
  @ApiModelProperty("业务扩展信息")
  private JSONObject data;
}
