package com.biz.crm.cps.business.activity.scan.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 扫码活动返利奖励配置信息vo
 *
 * @author sunx
 * @date 2022-02-16 16:40:11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "扫码活动返利奖励配置信息Vo")
public class ScanActivityRebateVo {
  /** 活动编码 */
  @ApiModelProperty("活动编码")
  private String actCode;

  /** 奖励配置编码 */
  @ApiModelProperty("奖励配置编码")
  private String rewardCode;

  /** 返利奖励配置编码 */
  @ApiModelProperty("返利奖励配置编码")
  private String rebateCode;

  /** 对象类型 ScanActivityRebateObjTypeEnum */
  @ApiModelProperty("对象类型，customer-经销商、terminal-终端")
  private String objType;

  /** 奖励类型 ScanActivityRewardTypeEnum */
  @ApiModelProperty("奖励类型，red_packet-红包，point-积分，fee-费用")
  private String rewardType;

  /** 是否随机 */
  @ApiModelProperty("是否随机")
  private Boolean randomFlag;

  /** 排序 */
  @ApiModelProperty("排序")
  private Integer sort;

  /** 配置明细 */
  @ApiModelProperty("配置明细")
  private List<ScanActivityRebateValueVo> valueList;
}
