package com.biz.crm.cps.business.activity.scan.sdk.vo;

import java.util.List;
import lombok.Data;

/**
 * 奖励发放观察者实现的参数dto
 *
 * @author sunx
 * @date 2022/3/11
 */
@Data
public class ScanActivityRewardObserverVo {
  /**
   * 参与对象,customer-经销商,terminal-终端
   *
   * @see ScanActivityParticipateObjEnum
   */
  private String participateObj;
  /** 扫码活动编码 */
  private String scanActCode;
  /** 红包发放账户编码 */
  private String accountCode;
  /** 参与者业务编码，经销商编码、终端编码、导购编码、消费者编码 */
  private String userCode;
  /** 参与者业务名称，经销商、终端、导购、消费者 */
  private String name;
  /** 物料编码 */
  private String materialCode;
  /** 触发动作 */
  private String triggerAction;
  /** 扫码记录编码 */
  private String recordCode;
  /** 渠道 */
  private String channel;
  /** 组织编码 */
  private String orgCode;
  /** 组织名称 */
  private String orgName;
  /**
   * 奖励类型,red_packet-红包，point-积分，fee-费用
   *
   * @see ScanActivityRewardTypeEnum
   */
  private String rewardType;
  /** 是否随机发放奖励 */
  private Boolean randomFlag;
  /** 发放金额概率配置 */
  private List<RewardValueVo> valueList;
  /** 反向分利明细信息 */
  private List<ScanActivityRewardObserverVo> itemList;
}
