package com.biz.crm.cps.business.activity.sdk.constant;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:收益状态
 * @Author: hecheng
 **/
public enum CountStatusEnum {
  /**
   * 增加
   */
  ADD("add", "1", "增加", "1"),

  /**
   * 减少
   */
  SUBTRACT("subtract", "2", "减少", "2");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CountStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
  /**
   * 通过key获取 IncomeStatusEnum
   *
   * @param key
   * @return
   */
  public static CountStatusEnum getByKey(String key) {
    return Arrays.stream(CountStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }
  /**
   * 通过dictCode获取 IncomeStatusEnum
   *
   * @param dictCode
   * @return
   */
  public static CountStatusEnum getByDictCode(String dictCode) {
    return Arrays.stream(CountStatusEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
            .findFirst().orElse(null);
  }
}

