package com.biz.crm.cps.business.activity.sdk.constant;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author songjingen
 * @Description: 参与者类型
 **/
public enum RewardTypeEnum {
  /**
   * 编码与描述
   */
  REDPACKET("redpacket", "1","红包", "3"),
  INTEGRAL("integral", "2","积分", "3"),
  COST("cost", "3","费用", "2"),
  GIFT("gift", "4","赠品", "1");


  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  RewardTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  public String getDictCode() {
    return dictCode;
  }

  /**
   * 通过key获取 ParticipatorTypeEnum
   *
   * @param key
   * @return
   */
  public static RewardTypeEnum getByKey(String key) {
    return Arrays.stream(RewardTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 ParticipatorTypeEnum
   *
   * @param value
   * @return
   */
  public static RewardTypeEnum getByValue(String value) {
    return Arrays.stream(RewardTypeEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
        .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 ParticipatorTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static RewardTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(RewardTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
            .findFirst().orElse(null);
  }
}

