package com.biz.crm.cps.business.activity.sdk.dto;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 将奖励条件公式 传递到 奖励模块的dto
 * 奖励模块组使用该dto可以计算奖励最终值，并记录流水
 * @author hefan
 */
@Data
public class ActivityRewardConditionDto implements Serializable {
  private static final long serialVersionUID = 481390927353893478L;

  /**
   * 必传
   * 得到这份奖励的参与者(分利参与者 标记）1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("得到这份奖励的参与者(分利参与者 标记）")
  private String participatorFlag;

  /**
   *必传
   * 得到这份奖励的参与者(分利参与者 中文名）1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("得到这份奖励的参与者(分利参与者 中文名）")
  private String participatorName;

  /**
   * 奖励方式标志（费用，红包，等等） 必传
   */
  @ApiModelProperty("奖励方式标志（费用，红包，等等）")
  private String rewardMethodFlag;

  /**
   * 奖励方式名称（费用，红包，等等） 必传
   */
  @ApiModelProperty("奖励方式名称（费用，红包，等等）")
  private String rewardMethodName;

  /**
   * 奖励条件标志(固定额度，定额随机) 必传
   */
  @ApiModelProperty("奖励条件标志(固定额度，定额随机)")
  private String awardConditionFlag;

  /**
   * 奖励条件名称(固定额度，定额随机) 必传
   */
  @ApiModelProperty("奖励条件名称(固定额度，定额随机)")
  private String awardConditionName;

  /**
   * 奖励数据 必传
   */
  @ApiModelProperty("奖励数据")
  private String rewardData;

  /**
   * 参与者编码（实际扫码者）必传
   */
  @ApiModelProperty("参与者编码（实际扫码者）")
  private String actualParticipatorCode;

  /**
   * 参与者标记（实际扫码者）必传
   */
  @ApiModelProperty("参与者标记（实际扫码者）")
  private String actualParticipatorFlag;

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("政策名称")
  private String policyName;

  /**
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  private String triggerObject;

  /**
   * 协议
   */
  @ApiModelProperty("协议")
  private String agreementCode;

  /**
   * 模版编码
   */
  @ApiModelProperty("模版编码")
  private String templateCode;
  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  private String recordCode;
  /**
   * 赠品编码
   */
  @ApiModelProperty("赠品编码")
  private String giftCode;
  /**
   * 奖项编码
   */
  @ApiModelProperty("奖项编码")
  private String rewardCode;
  /**
   * 传递奖励
   */
  @ApiModelProperty("传递奖励")
  List<ActivityRewardConditionDto> activityRewardConditionDtos;


}
