package com.biz.crm.cps.business.activity.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author: zengxingwang
 * @Date: 2021/10/26 10:21
 */
@Data
public class LotteryDto {

  /**
   * 抽奖活动编码
   */
  @ApiModelProperty(name = "activityCode", value = "抽奖活动编码")
  private String activityCode;

  /**
   * 参与者编码
   */
  @ApiModelProperty(name = "participatorCode", value = "参与者编码")
  private String participatorCode;

  /**
   * 活动方式
   */
  @ApiModelProperty(name = "activityMethodFlag", value = "活动方式")
  private String activityMethodFlag;

  /**
   * 必传
   * 得到这份奖励的参与者(分利参与者 标记）1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("得到这份奖励的参与者(分利参与者 标记）")
  private String participatorFlag;

  /**
   * 奖励方式标志（费用，红包，等等） 必传
   */
  @ApiModelProperty("奖励方式标志（费用，红包，等等）")
  private String rewardMethodFlag;

  /**
   * 奖励方式名称（费用，红包，等等） 必传
   */
  @ApiModelProperty("奖励方式名称（费用，红包，等等）")
  private String rewardMethodName;

  /**
   * 参与者编码（实际扫码者）必传
   */
  @ApiModelProperty("参与者编码（实际扫码者）")
  private String actualParticipatorCode;

  /**
   * 参与者标记（实际扫码者）必传
   */
  @ApiModelProperty("参与者标记（实际扫码者）")
  private String actualParticipatorFlag;

  /**
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  private String triggerObject;

  /**
   * 扫码编码必传
   */
  @ApiModelProperty("扫码编码必传")
  private String recordCode;
}
