package com.biz.crm.cps.business.activity.sdk.observer;

import com.biz.crm.cps.business.activity.sdk.dto.ActivityRewardConditionDto;

import java.util.List;

/**
 * 协议奖励服务观察者
 * 奖励模块组需要实现该观察者接口，当有事件发生时。内部逻辑会调用各个奖励模块提供的方法
 * @author hefan
 */
public interface ActivityRewardServiceObserver {

  /**
   * 方法内部流程：
   * 根据奖励方式判断是否计算--入参
   * 根据计算方式选择策略--入参
   * 根据条件计算结果，保存流水--流水冗余信息确定传入
   * 判断是否有传递奖励
   * 将分利规则集合，告知流水模块组的观察者们。---参照ScanCodeRecordEventListenerImpl
   *
   * @param activityRewardConditionDtos
   */
  void createRewardRecord(List<ActivityRewardConditionDto> activityRewardConditionDtos);

}
