/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.biz.crm.cps.business.agreement.local.entity.AgreementSign;
import com.biz.crm.cps.business.agreement.local.repository.AgreementRepository;
import com.biz.crm.cps.business.agreement.local.repository.AgreementSignRepository;
import com.biz.crm.cps.business.agreement.local.service.AgreementSignService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignatoryEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AgreementSignServiceImpl
implements AgreementSignService {
    @Resource
    private AgreementSignRepository agreementSignRepository;
    @Resource
    private AgreementRepository agreementRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public AgreementSign create(AgreementSign agreementSign) {
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u767b\u5f55\u4fe1\u606f\uff01", (Object[])new Object[0]);
        this.createValidation(agreementSign);
        this.agreementRepository.updateDealerSignStatusById(SignStatusEnum.SIGNED, agreementSign.getAgreementCode());
        agreementSign.setSignatory(SignatoryEnum.DEALER.getCode());
        agreementSign.setSignDate(new Date());
        agreementSign.setTenantCode(TenantUtils.getTenantCode());
        agreementSign.setSignatoryName(this.loginUserService.getLoginAccountName());
        agreementSign.setSignatoryCode(loginUser.getUsername());
        agreementSign.setSignAccount(this.loginUserService.getLoginAccountName());
        this.agreementSignRepository.saveOrUpdate((Object)agreementSign);
        return agreementSign;
    }

    private void createValidation(AgreementSign agreementSign) {
        Validate.notNull((Object)((Object)agreementSign), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)agreementSign.getAgreementCode(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u534f\u8bae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)agreementSign.getSignatureFilename(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)agreementSign.getSignaturePath(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((agreementSign.getAgreementCode() == null || agreementSign.getAgreementCode().length() < 128 ? 1 : 0) != 0, (String)"\u534f\u8bae\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((agreementSign.getSignatureFilename() == null || agreementSign.getSignatureFilename().length() < 255 ? 1 : 0) != 0, (String)"\u534f\u8bae\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((agreementSign.getSignaturePath() == null || agreementSign.getSignaturePath().length() < 255 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u534f\u8bae\u6a21\u677f\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

