/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.AgreementSign;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.repository.AgreementRepository;
import com.biz.crm.cps.business.agreement.local.repository.AgreementSignRepository;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateRepository;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AutoSignEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignatoryEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignEventDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementSignObserver;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.SupplyRelationshipVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AgreementServiceImpl
implements AgreementService {
    @Autowired
    private AgreementRepository agreementRepository;
    @Autowired
    private AgreementSignRepository agreementSignRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private DealerVoService dealerVoService;
    @Autowired
    private ProfitAgreementTemplateRepository profitAgreementTemplateRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<AgreementSignObserver> agreementSignObservers;

    @Override
    @Transactional
    public void enable(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<Agreement> agreements = this.agreementRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(agreements) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7b7e\u7f72\u7684\u534f\u8bae", (Object[])new Object[0]);
        List<Agreement> collect = agreements.stream().filter(agreement -> SignStatusEnum.SIGNING.getCode().equals(agreement.getSignStatus())).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(collect) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7b7e\u7f72\u7684\u534f\u8bae", (Object[])new Object[0]);
        ArrayList agreementSigns = new ArrayList();
        Date date = new Date();
        collect.forEach(agreement -> {
            agreement.setSignStatus(SignStatusEnum.SIGNED.getCode());
            AgreementSign agreementSign = new AgreementSign();
            agreementSign.setId(null);
            agreementSign.setSignatory(SignatoryEnum.DEALER.getCode());
            agreementSign.setSignatoryCode(this.loginUserService.getLoginAccountName());
            agreementSign.setSignatoryName(this.loginUserService.getLoginAccountName());
            agreementSign.setSignDate(date);
            agreementSign.setSignAccount(this.loginUserService.getLoginAccountName());
            agreementSign.setTenantCode(TenantUtils.getTenantCode());
            agreementSign.setAgreementCode(agreement.getAgreementCode());
            agreementSigns.add(agreementSign);
        });
        this.agreementRepository.saveOrUpdateBatch(collect);
        this.agreementSignRepository.saveOrUpdateBatch(agreementSigns);
        collect.stream().forEach(agreement -> this.notifyEvent((Agreement)((Object)agreement)));
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<Agreement> agreements = this.agreementRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(agreements) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7ec8\u6b62\u7684\u534f\u8bae", (Object[])new Object[0]);
        List<String> newIds = agreements.stream().filter(agreement -> SignStatusEnum.SIGNED.getCode().equals(agreement.getSignStatus())).map(BaseIdEntity::getId).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(newIds) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7ec8\u6b62\u7684\u534f\u8bae", (Object[])new Object[0]);
        this.agreementRepository.updateAgreementStatusByIds(AgreementStatusEnum.TERMINATED, newIds);
    }

    @Override
    @Transactional
    public void disableByTemplateCodes(List<String> templateCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(templateCodes) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<Agreement> agreementList = this.findByTemplateCodes(templateCodes);
        Validate.isTrue((!CollectionUtils.isEmpty(agreementList) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7ec8\u6b62\u7684\u534f\u8bae", (Object[])new Object[0]);
        agreementList.stream().forEach(agreement -> agreement.setAgreementStatus(AgreementStatusEnum.TERMINATED.getCode()));
        this.agreementRepository.saveOrUpdateBatch(agreementList);
    }

    @Override
    @Transactional
    public Agreement create(AgreementSignDto dto) {
        ProfitAgreementTemplate profitAgreementTemplate;
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        this.createValidation(dto);
        Agreement agreement = this.createForm(dto, loginUser);
        this.agreementRepository.saveOrUpdate((Object)agreement);
        List<AgreementSign> agreementSigns = this.createAgreementSignForm(dto, loginUser, agreement);
        this.agreementSignRepository.saveBatch(agreementSigns);
        if (SignStatusEnum.SIGNED.getCode().equals(agreement.getSignStatus())) {
            this.notifyEvent(agreement);
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{profitAgreementTemplate = this.profitAgreementTemplateRepository.findByTemplateCode(dto.getTemplateCode())})) {
            Integer generatedAgreementNumber = profitAgreementTemplate.getGeneratedAgreementNumber();
            Integer n = generatedAgreementNumber = Integer.valueOf(Objects.isNull(generatedAgreementNumber) ? 0 : generatedAgreementNumber);
            Integer n2 = generatedAgreementNumber = Integer.valueOf(generatedAgreementNumber + 1);
            profitAgreementTemplate.setGeneratedAgreementNumber(generatedAgreementNumber);
            this.profitAgreementTemplateRepository.updateById((Object)profitAgreementTemplate);
        }
        return agreement;
    }

    private void notifyEvent(Agreement agreement) {
        if (CollectionUtils.isEmpty(this.agreementSignObservers)) {
            return;
        }
        if (Objects.isNull((Object)agreement)) {
            return;
        }
        AgreementSignEventDto agreementSignEventDto = (AgreementSignEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreement, AgreementSignEventDto.class, null, null, new String[0]);
        for (AgreementSignObserver agreementSignObserver : this.agreementSignObservers) {
            agreementSignObserver.onSuccess(agreementSignEventDto);
        }
    }

    private Agreement createForm(AgreementSignDto dto, LoginUserDetails loginUser) {
        this.findByTemplateCodeAndTerminalCode(dto.getTemplateCode(), loginUser.getConsumerCode());
        ProfitAgreementTemplate template = this.profitAgreementTemplateRepository.findByTemplateCode(dto.getTemplateCode());
        Validate.notNull((Object)((Object)template), (String)"\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        Date date = new Date();
        Validate.isTrue((date.after(template.getSignStartTime()) && date.before(template.getSignEndTime()) ? 1 : 0) != 0, (String)"\u4e0d\u5728\u89c4\u5b9a\u7684\u7b7e\u7f72\u65f6\u95f4\u8303\u56f4\u5185\uff01", (Object[])new Object[0]);
        TerminalVo terminalVo = this.findTerminalByTerminalCode(loginUser.getConsumerCode(), template.getTemplateName());
        if (StringUtils.isBlank((CharSequence)dto.getCustomerCode())) {
            ArrayList supplyRelationshipVos = new ArrayList(terminalVo.getSupplyRelationships());
            Validate.notNull(supplyRelationshipVos, (String)"\u5f53\u524d\u4f9b\u8d27\u5173\u7cfb\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            dto.setCustomerCode(((SupplyRelationshipVo)supplyRelationshipVos.get(0)).getExternalIdentifier());
        }
        DealerVo dealerVo = this.dealerVoService.findByCustomerCode(dto.getCustomerCode());
        Validate.notNull((Object)dealerVo, (String)"\u5f53\u524d\u7ec8\u7aef\u6240\u5c5e\u7ecf\u9500\u5546\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Agreement agreement = new Agreement();
        agreement.setAgreementCode((String)this.generateCodeService.generateCode("agreement", 1).get(0));
        agreement.setAgreementName(StringUtils.joinWith((String)"-", (Object[])new Object[]{template.getTemplateName(), terminalVo.getTerminalName()}));
        agreement.setTemplateCode(dto.getTemplateCode());
        agreement.setBelongTemplate(template.getTemplateName());
        agreement.setTerminalCode(terminalVo.getTerminalCode());
        agreement.setRelationTerminal(terminalVo.getTerminalName());
        agreement.setCustomerCode(dealerVo.getCustomerCode());
        agreement.setRelationDealer(dealerVo.getCustomerName());
        agreement.setTerminalSignStatus(SignStatusEnum.SIGNED.getCode());
        agreement.setDealerSignStatus(SignStatusEnum.SIGNED.getCode());
        agreement.setTenantCode(TenantUtils.getTenantCode());
        agreement.setCreateTime(date);
        agreement.setCreateAccount(this.loginUserService.getLoginAccountName());
        agreement.setModifyTime(date);
        agreement.setModifyAccount(this.loginUserService.getLoginAccountName());
        if (AutoSignEnum.YES.getCode().equals(template.getAutoSign())) {
            agreement.setSignStatus(SignStatusEnum.SIGNED.getCode());
        } else {
            agreement.setSignStatus(SignStatusEnum.SIGNING.getCode());
        }
        if (date.before(template.getEffectiveStartTime())) {
            agreement.setAgreementStatus(AgreementStatusEnum.NOT_STARTED.getCode());
        } else if (date.after(template.getEffectiveStartTime()) && date.before(template.getEffectiveEndTime())) {
            agreement.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        } else {
            agreement.setAgreementStatus(AgreementStatusEnum.COMPLETED.getCode());
        }
        return agreement;
    }

    @Override
    public Agreement findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return (Agreement)((Object)this.agreementRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public Agreement findDetailsById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Agreement agreement = this.agreementRepository.findDetailsById(id);
        return agreement;
    }

    @Override
    public Page<Agreement> findByConditions(Pageable pageable, AgreementDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AgreementDto();
        }
        return this.agreementRepository.findByConditions(pageable, dto);
    }

    @Override
    public List<Agreement> findByCurrentTime(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        return this.agreementRepository.findByCurrentTime(date);
    }

    @Override
    @Transactional
    public void createOrUpdateBatch(List<Agreement> list) {
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u6279\u91cf\u64cd\u4f5c\u65f6\uff0c\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.agreementRepository.saveOrUpdateBatch(list);
    }

    @Override
    public List<Agreement> findByTemplateCodes(List<String> templateCodes) {
        if (CollectionUtils.isEmpty(templateCodes)) {
            return null;
        }
        return this.agreementRepository.findByTemplateCodes(templateCodes);
    }

    private void createValidation(AgreementSignDto dto) {
        Validate.notNull((Object)dto, (String)"\u7b7e\u7f72\u64cd\u4f5c\u65f6\uff0c\u7b7e\u7f72\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTemplateCode(), (String)"\u7b7e\u7f72\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSignaturePath(), (String)"\u7b7e\u7f72\u64cd\u4f5c\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSignatureFilename(), (String)"\u7b7e\u7f72\u64cd\u4f5c\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private List<AgreementSign> createAgreementSignForm(AgreementSignDto dto, LoginUserDetails loginUser, Agreement agreement) {
        ArrayList<AgreementSign> signList = new ArrayList<AgreementSign>();
        AgreementSign dealerAgreementSign = new AgreementSign();
        dealerAgreementSign.setAgreementCode(agreement.getAgreementCode());
        dealerAgreementSign.setSignatory(SignatoryEnum.DEALER.getCode());
        dealerAgreementSign.setSignatoryCode(agreement.getCustomerCode());
        dealerAgreementSign.setSignatoryName(agreement.getRelationDealer());
        dealerAgreementSign.setSignDate(new Date());
        dealerAgreementSign.setSignAccount(agreement.getRelationDealer());
        dealerAgreementSign.setTenantCode(TenantUtils.getTenantCode());
        AgreementSign terminalAgreementSign = (AgreementSign)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealerAgreementSign, AgreementSign.class, null, null, new String[0]));
        terminalAgreementSign.setSignatureFilename(dto.getSignatureFilename());
        terminalAgreementSign.setSignaturePath(dto.getSignaturePath());
        terminalAgreementSign.setSignatory(SignatoryEnum.TERMINAL.getCode());
        terminalAgreementSign.setSignatoryCode(agreement.getTerminalCode());
        terminalAgreementSign.setSignatoryName(agreement.getBelongTemplate());
        terminalAgreementSign.setSignAccount(agreement.getBelongTemplate());
        AgreementSign agreementSign = (AgreementSign)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealerAgreementSign, AgreementSign.class, null, null, new String[0]));
        agreementSign.setSignatory(SignatoryEnum.BRAND.getCode());
        agreementSign.setSignatoryCode(loginUser.getConsumerCode());
        agreementSign.setSignatoryName(this.loginUserService.getLoginAccountName());
        agreementSign.setSignAccount(this.loginUserService.getLoginAccountName());
        signList.add(dealerAgreementSign);
        signList.add(terminalAgreementSign);
        if (SignStatusEnum.SIGNED.getCode().equals(agreement.getSignStatus())) {
            signList.add(agreementSign);
        }
        return signList;
    }

    private void findByTemplateCodeAndTerminalCode(String templateCode, String terminalCode) {
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        ArrayList<String> templateCodes = new ArrayList<String>();
        templateCodes.add(templateCode);
        loginUserAgreementDto.setTemplateCodes(templateCodes);
        loginUserAgreementDto.setTerminalCode(terminalCode);
        List<Agreement> byConditions = this.agreementRepository.findByConditions(loginUserAgreementDto);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(byConditions), (String)"\u5df2\u7b7e\u7f72\u5f53\u524d\u534f\u8bae\uff01", (Object[])new Object[0]);
    }

    private TerminalVo findTerminalByTerminalCode(String terminalCode, String templateName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(terminalCode);
        List terminalVoList = this.terminalVoService.findByTerminalCodes(list);
        Validate.notNull((Object)terminalVoList, (String)"\u5f53\u524d\u7ec8\u7aef\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        TerminalVo terminalVo = (TerminalVo)terminalVoList.get(0);
        return terminalVo;
    }
}

