/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.repository.AgreementScanCodeRecordMappingRepository;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementScanCodeRecordMappingDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementScanCodeRecordMappingVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgreementScanCodeRecordMappingVoServiceImpl
implements AgreementScanCodeRecordMappingVoService {
    @Resource
    private AgreementScanCodeRecordMappingRepository agreementScanCodeRecordMappingRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public Page<AgreementVo> findByConditions(Pageable pageable, AgreementScanCodeRecordMappingDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new AgreementScanCodeRecordMappingDto();
        }
        Page<Agreement> byConditions = this.agreementScanCodeRecordMappingRepository.findByConditions(pageable, dto);
        ArrayList agreementVos = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
            byConditions.getRecords().stream().forEach(agreement -> {
                AgreementVo agreementVo = (AgreementVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreement, AgreementVo.class, null, null, new String[0]);
                ProfitAgreementTemplate profitAgreementTemplate = agreement.getProfitAgreementTemplate();
                if (profitAgreementTemplate != null) {
                    agreementVo.setEffectiveStartTime(profitAgreementTemplate.getEffectiveStartTime());
                    agreementVo.setEffectiveEndTime(profitAgreementTemplate.getEffectiveEndTime());
                    agreementVo.setSignStartTime(profitAgreementTemplate.getSignStartTime());
                    agreementVo.setSignEndTime(profitAgreementTemplate.getSignEndTime());
                }
                agreementVos.add(agreementVo);
            });
        }
        Page agreementVoPage = new Page();
        agreementVoPage.setCurrent(byConditions.getCurrent());
        agreementVoPage.setSize(byConditions.getSize());
        agreementVoPage.setTotal(byConditions.getTotal());
        agreementVoPage.setRecords(agreementVos);
        return agreementVoPage;
    }
}

