/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.AgreementSign;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.repository.AgreementRepository;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignatoryEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgreementVoServiceImpl
implements AgreementVoService {
    @Resource
    private AgreementRepository agreementRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;

    public List<AgreementVo> findByConditions(LoginUserAgreementDto dto) {
        List<Agreement> agreements;
        if (dto == null) {
            dto = new LoginUserAgreementDto();
        }
        if (CollectionUtils.isEmpty(agreements = this.agreementRepository.findByConditions(dto))) {
            return null;
        }
        List agreementVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(agreements, Agreement.class, AgreementVo.class, HashSet.class, ArrayList.class, new String[0]);
        return agreementVos;
    }

    public Page<AgreementVo> findByConditions(Pageable pageable, AgreementDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new AgreementDto();
        }
        Page<Agreement> byConditions = this.agreementRepository.findByConditions(pageable, dto);
        ArrayList agreementVos = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
            byConditions.getRecords().stream().forEach(agreement -> {
                AgreementVo agreementVo = (AgreementVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreement, AgreementVo.class, null, null, new String[0]);
                ProfitAgreementTemplate profitAgreementTemplate = agreement.getProfitAgreementTemplate();
                if (profitAgreementTemplate != null) {
                    agreementVo.setEffectiveStartTime(profitAgreementTemplate.getEffectiveStartTime());
                    agreementVo.setEffectiveEndTime(profitAgreementTemplate.getEffectiveEndTime());
                    agreementVo.setSignStartTime(profitAgreementTemplate.getSignStartTime());
                    agreementVo.setSignEndTime(profitAgreementTemplate.getSignEndTime());
                }
                agreementVos.add(agreementVo);
            });
        }
        Page agreementVoPage = new Page();
        agreementVoPage.setCurrent(byConditions.getCurrent());
        agreementVoPage.setSize(byConditions.getSize());
        agreementVoPage.setTotal(byConditions.getTotal());
        agreementVoPage.setRecords(agreementVos);
        return agreementVoPage;
    }

    public AgreementVo findById(String id) {
        List sign;
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Agreement agreement = this.agreementRepository.findDetailsById(id);
        if (Objects.isNull((Object)agreement)) {
            return null;
        }
        AgreementVo agreementVo = (AgreementVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreement, AgreementVo.class, null, null, new String[0]);
        if (Objects.isNull((Object)agreement.getProfitAgreementTemplate())) {
            return null;
        }
        Set<AgreementSign> agreementSigns = agreement.getAgreementSigns();
        if (!CollectionUtils.isEmpty(agreementSigns) && !CollectionUtils.isEmpty(sign = agreementSigns.stream().filter(agreementSign -> SignatoryEnum.TERMINAL.getCode().equals(agreementSign.getSignatory())).collect(Collectors.toList()))) {
            agreementVo.setSignaturePath(((AgreementSign)((Object)sign.get(0))).getSignaturePath());
            agreementVo.setSignatureFilename(((AgreementSign)((Object)sign.get(0))).getSignatureFilename());
        }
        agreementVo.setAgreementText(agreement.getProfitAgreementTemplate().getAgreementText());
        return agreementVo;
    }
}

