package com.biz.crm.cps.business.agreement.local.controller;

import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignDto;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 分利协议信息，相关的http接口
 * @author songjingen
 */
@Slf4j
@RestController
@RequestMapping("/v1/agreement/agreement")
@Api(tags = "分利协议信息")
public class AgreementController {

  @Autowired
  private AgreementService agreementService;

  /**
   * 查询分利协议基本信息详情
   * @param id
   * @return
   */
  @ApiOperation(value = "查询分利协议基本信息详情")
  @GetMapping("/{id}")
  public Result<Agreement> findById(@PathVariable @ApiParam(name = "id", value = "分利协议主键id") String id) {
    try {
      Agreement agreement = agreementService.findById(id);
      return Result.ok(agreement);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id签署（单个或者批量）
   * @param ids
   * @return
   */
  @ApiOperation(value = "根据id签署（单个或者批量）")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody @ApiParam(name = "ids", value = "主键集合") List<String> ids) {
    try {
      agreementService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id终止（单个或者批量）
   * @param ids
   * @return
   */
  @ApiOperation(value = "根据id终止（单个或者批量）")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody @ApiParam(name = "ids", value = "主键集合") List<String> ids) {
    try {
      agreementService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 协议新增（终端签署）
   * @param dto
   * @return
   */
  @ApiOperation(value = "协议新增（终端签署）")
  @PostMapping
  public Result<?> create(@RequestBody @ApiParam(name = "agreement", value = "分利协议信息") AgreementSignDto dto) {
    try {
      agreementService.create(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询分利协议基本信息详情包含签署情况
   * @param id
   * @return
   */
  @ApiOperation(value = "查询分利协议基本信息详情包含签署情况")
  @GetMapping("/findDetailsById")
  public Result<Agreement> findDetailsById(@RequestParam("id") @ApiParam(name = "id", value = "分利协议主键id") String id) {
    try {
      Agreement agreement = agreementService.findDetailsById(id);
      return Result.ok(agreement);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id撤销终止（单个或者批量）
   * @param ids
   * @return
   */
  @ApiOperation(value = "根据id撤销终止（单个或者批量）")
  @PatchMapping("/revoke")
  public Result<?> revoke(@RequestBody @ApiParam(name = "ids", value = "主键集合") List<String> ids) {
    try {
      agreementService.revoke(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
