package com.biz.crm.cps.business.agreement.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.AgreementLadder;
import com.biz.crm.cps.business.agreement.local.service.AgreementLadderService;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementLadderDto;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 协议阶梯接口
 *
 * @author jerry7
 */
@Slf4j
@RestController
@RequestMapping("/v1/agreement/agreementLadder")
@Api(tags = "协议阶梯")
public class AgreementLadderController {

  @Autowired
  private AgreementLadderService agreementLadderService;

  /**
   * 协议阶梯新增
   *
   * @param agreementLadder 协议阶梯对象
   * @return 新增结果
   */
  @ApiOperation(value = "协议阶梯新增")
  @PostMapping
  public Result<AgreementLadder> create(@RequestBody @ApiParam(name = "agreement", value = "分利协议信息") AgreementLadder agreementLadder) {
    try {
      AgreementLadder current = agreementLadderService.create(agreementLadder);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分利协议信息分页条件查询
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "协议阶梯信息分页条件查询")
  @GetMapping("/findByConditions")
  public Result<Page<AgreementLadder>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                    @ApiParam(name = "dto", value = "分利协议信息分页条件查询dto") AgreementLadderDto dto) {
    try {
      Page<AgreementLadder> page = this.agreementLadderService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据协议阶梯编码查询阶梯实体
   *
   * @param ladderCode 协议阶梯编码
   * @return a
   */
  @ApiOperation(value = "根据协议阶梯编码查询阶梯实体")
  @GetMapping("/findByLadderCode")
  public Result<AgreementLadder> findByLadderCode(@RequestParam("ladderCode") String ladderCode) {
    try {
      AgreementLadder agreementLadder = this.agreementLadderService.findByLadderCode(ladderCode);
      return Result.ok(agreementLadder);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.agreementLadderService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.agreementLadderService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
