package com.biz.crm.cps.business.agreement.local.controller;

import com.biz.crm.cps.business.agreement.local.entity.AgreementSign;
import com.biz.crm.cps.business.agreement.local.service.AgreementSignService;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 分利协议签署，相关的http接口
 * @author songjingen
 */
@Slf4j
@RestController
@RequestMapping("/v1/agreement/agreementSign")
@Api(tags = "分利协议信息")
public class AgreementSignController {

  @Resource
  private AgreementSignService agreementSignService;

  /**
   * 新增协议签署（经销商签署）
   * @param agreementSign
   * @return
   */
  @ApiOperation(value = "新增协议签署（经销商签署）")
  @PostMapping
  public Result<AgreementSign> create(@RequestBody @ApiParam(name = "agreementSign", value = "分利协议签署信息") AgreementSign agreementSign) {
    try {
      AgreementSign current = agreementSignService.create(agreementSign);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
