package com.biz.crm.cps.business.agreement.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.service.ProfitAgreementTemplateService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.bizunited.nebula.common.util.JsonUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

/**
 * @author jerry7
 * @date 2021-07-21
 *  分利协议模板接口
 */
@Api(tags = "分利协议模板")
@Slf4j
@RestController
@RequestMapping("/v1/agreement/template")
public class AgreementTemplateController {

  @Autowired
  private ProfitAgreementTemplateService profitAgreementTemplateService;


  /**
   * 创建分利协议模板
   * @param agreementTemplate 分利协议实体
   * @return 创建后的分离协议实体
   */
  @ApiOperation(value = "创建协议模板")
  @PostMapping(value="")
  public Result<ProfitAgreementTemplate> create(@RequestBody @ApiParam(name="agreementTemplate" , value="创建协议模板") ProfitAgreementTemplate agreementTemplate) {
    try {
      ProfitAgreementTemplate current = this.profitAgreementTemplateService.create(agreementTemplate);
      return Result.ok(current);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建分利协议模板
   * @return 创建后的分离协议实体
   */
  @ApiOperation(value = "创建协议模板")
  @PostMapping(value="createDetails")
  public Result<ProfitAgreementTemplate> createDetails(HttpServletRequest request) {
    try {
      // 从请求信息中获取body信息
      BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream()));
      String body = IOUtils.toString(reader);
      JSONObject jsonObject = JsonUtils.toJSONObject(body);
      ProfitAgreementTemplate current = this.profitAgreementTemplateService.create(jsonObject);
      return Result.ok(current);
    } catch(RuntimeException | IOException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据主键id查询协议模板信息(不包含关联信息)
   * @param id 主键id
   * @return 协议模板数据
   */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public Result<ProfitAgreementTemplate> findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){
    try {
      ProfitAgreementTemplate current = this.profitAgreementTemplateService.findById(id);
      return Result.ok(current);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据主键查询协议模板，包含关联信息
   * @param id 主键
   */
  @ApiOperation(value = "根据主键查询协议模板，包含关联信息")
  @GetMapping(value="/findDetailsById")
  public Result<ProfitAgreementTemplate> findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      ProfitAgreementTemplate result = this.profitAgreementTemplateService.findDetailsById(id);
      return Result.ok(result);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.profitAgreementTemplateService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.profitAgreementTemplateService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改分利协议模板
   * @return 修改分利协议模板
   */
  @ApiOperation(value = "修改分利协议模板")
  @PatchMapping(value="update")
  public Result<ProfitAgreementTemplate> update(HttpServletRequest request) {
    try {
      // 从请求信息中获取body信息
      BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream()));
      String body = IOUtils.toString(reader);
      JSONObject jsonObject = JsonUtils.toJSONObject(body);
      ProfitAgreementTemplate current = this.profitAgreementTemplateService.update(jsonObject);
      return Result.ok(current);
    } catch(RuntimeException | IOException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
