package com.biz.crm.cps.business.agreement.local.controller;

import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateDetailsVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateDetailsVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 分利协议政策挂载信息
 * @author hefan
 */
@Api(tags = "分利协议政策挂载信息")
@Slf4j
@RestController
@RequestMapping("/v1/agreement/template")
public class AgreementTemplateDetailsVoController {

  @Resource
  private AgreementTemplateDetailsVoService agreementTemplateDetailsVoService;

  /**
   * 查询协议模板及其政策的详细信息
   */
  @ApiOperation(value = "查询协议模板及其政策的详细信息")
  @GetMapping(value = "/findPolicyDetailsById")
  public Result<AgreementTemplateDetailsVo> findDetailsById(@RequestParam(value = "id") @ApiParam(name= "id", value = "协议模板ID") String id) {
    try {
      AgreementTemplateDetailsVo current = this.agreementTemplateDetailsVoService.findDetailsById(id);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
