package com.biz.crm.cps.business.agreement.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author jerry7
 * @date 2021-07-21
 * 分利协议模板VO接口
 */
@Api(tags = "分利协议模板")
@Slf4j
@RestController
@RequestMapping("/v1/agreement/template")
public class AgreementTemplateVoController {

  @Resource
  private AgreementTemplateVoService agreementTemplateVoService;

  /**
   * 根据条件分页查询模板VO
   *
   * @param pageable 分页信息
   * @param dto      包含查询条件的请求
   * @return 协议模板VO列表
   */
  @ApiOperation(value = "多条件分页查询VO", notes = "分页参数为page和size，page从0开始，size默认50;" +
          "可传的参数：templateCode 模板编码，templateName 模板名称，orgCode 所属组织，channelCode 渠道编码")
  @GetMapping("findByConditions")
  public Result<Page<AgreementTemplateVo>> findByConditions(@PageableDefault(50) Pageable pageable, @ApiParam(name = "profitAgreementTemplatePaginationDto", value = "终端分页Dto") ProfitAgreementTemplatePaginationDto dto) {
    try {
      Page<AgreementTemplateVo> result = this.agreementTemplateVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * H5终端未签署展示的模板信息
   *
   * @param pageable 分页信息
   * @param dto      包含查询条件的请求
   * @return 协议模板VO列表
   */
  @ApiOperation(value = "H5终端未签署展示的模板信息", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findListByConditions")
  public Result<Page<AgreementTemplateVo>> findListByConditions(@PageableDefault(50) Pageable pageable, @ApiParam(name = "profitAgreementTemplatePaginationDto", value = "终端分页Dto") ProfitAgreementTemplatePaginationDto dto) {
    try {
      Page<AgreementTemplateVo> result = this.agreementTemplateVoService.findListByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
