package com.biz.crm.cps.business.agreement.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 分利协议信息vo相关的http接口
 * @author songjingen
 */
@Slf4j
@RestController
@RequestMapping("/v1/agreement/agreement")
@Api(tags = "分利协议信息")
public class AgreementVoController {

  @Resource
  private AgreementVoService agreementVoService;

  /**
   * 分利协议信息分页条件查询
   * @param dto
   * @return
   */
  @ApiOperation(value = "分利协议信息分页条件查询")
  @GetMapping("/findByConditions")
  public Result<Page<AgreementVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                    @ApiParam(name = "dto", value = "分利协议信息分页条件查询dto") AgreementDto dto) {
    try {
      Page<AgreementVo> page =  agreementVoService.findByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询协议信息，关联协议文本和终端签名
   * @param id
   * @return
   */
  @ApiOperation(value = "查询协议信息，关联协议文本和终端签名")
  @GetMapping("/findById")
  public Result<AgreementVo> findById(@ApiParam(name = "id", value = "id") @RequestParam String id) {
    try {
      AgreementVo agreementVo =  agreementVoService.findById(id);
      return Result.ok(agreementVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询当前用户的协议信息是否存在
   * @return
   */
  @ApiOperation(value = "查询当前用户的协议信息是否存在")
  @GetMapping("/findExistByCurrentUser")
  public Result<Boolean> findExistByCurrentUser() {
    try {
      Boolean b = this.agreementVoService.findExistByCurrentUser();
      return Result.ok(b);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询当前登录用户的协议信息
   * @param dto
   * @return
   */
  @ApiOperation(value = "查询当前登录用户的协议信息")
  @GetMapping("/findByLoginUser")
  public Result<List<AgreementVo>> findByLoginUser(@ApiParam(name = "dto", value = "当前登陆人协议信息dto") LoginUserAgreementDto dto) {
    try {
      List<AgreementVo> AgreementVos =  agreementVoService.findByConditions(dto);
      return Result.ok(AgreementVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
