package com.biz.crm.cps.business.agreement.local.controller;

import com.biz.crm.cps.business.agreement.sdk.service.PolicyMountVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyMountVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 分利协议政策挂载信息
 * @author hefan
 */
@Api(tags = "分利协议政策挂载信息")
@Slf4j
@RestController
@RequestMapping("/v1/agreement/mount")
public class PolicyMountVoController {

  @Autowired
  private PolicyMountVoService policyMountVoService;

  /**
   * 查询系统中存在的协议政策
   */
  @ApiOperation(value = "查询系统中存在的协议政策")
  @GetMapping(value = "/findPolicy")
  public Result<List<PolicyMountVo>> findPolicy() {
    try {
      List<PolicyMountVo> current = this.policyMountVoService.findPolicy();
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
