package com.biz.crm.cps.business.agreement.local.controller;

import com.biz.crm.cps.business.agreement.sdk.service.PolicyRewardDataVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyRewardDataVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 政策奖励数据信息vo
 * @author hefan
 */
@Api(tags = "政策奖励数据信息vo")
@Slf4j
@RestController
@RequestMapping("/v1/agreement/reward")
public class PolicyRewardDataVoController {

  @Autowired
  private PolicyRewardDataVoService policyRewardDataVoService;

  /**
   * 查询政策奖励数据信息vo
   */
  @ApiOperation(value = "查询政策奖励数据信息vo")
  @GetMapping(value = "/findPolicyRewardData")
  public Result<List<PolicyRewardDataVo>> findPolicy() {
    try {
      List<PolicyRewardDataVo> current = this.policyRewardDataVoService.findPolicyRewardData();
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
