package com.biz.crm.cps.business.agreement.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateDetailLog;
import com.biz.crm.cps.business.agreement.local.service.ProfitAgreementTemplateDetailLogService;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 模板日志明细
 * @Author: zengxingwang
 * @Date: 2021/11/19 11:25
 */
@Slf4j
@RestController
@RequestMapping("/v1/agreement/detailLog")
@Api(tags = "模板日志明细")
public class ProfitAgreementTemplateDetailLogController {

  @Autowired
  private ProfitAgreementTemplateDetailLogService agreementTemplateDetailLogService;

  /**
   * 日志明细查询
   * @param pageable
   * @param logId
   * @return
   */
  @ApiOperation(value = "日志明细查询")
  @GetMapping("/findByLogId")
  public Result<Page<ProfitAgreementTemplateDetailLog>> findByLogId(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                    @ApiParam(name = "logId", value = "日志id") String logId) {
    try {
      Page<ProfitAgreementTemplateDetailLog> page = this.agreementTemplateDetailLogService.findByLogId(pageable, logId);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
