package com.biz.crm.cps.business.agreement.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateLog;
import com.biz.crm.cps.business.agreement.local.service.ProfitAgreementTemplateLogService;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplateLogDto;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 模板日志
 * @Author: zengxingwang
 * @Date: 2021/11/19 11:25
 */
@Slf4j
@RestController
@RequestMapping("/v1/agreement/log")
@Api(tags = "模板日志")
public class ProfitAgreementTemplateLogController {

  @Autowired
  private ProfitAgreementTemplateLogService agreementTemplateLogService;
  /**
   * 保存日志
   * @param templateLog
   * @return
   */
  @ApiOperation(value = "保存日志")
  @PostMapping
  public Result<ProfitAgreementTemplateLog> create(@RequestBody @ApiParam(name = "log", value = "日志") ProfitAgreementTemplateLog templateLog) {
    try {
      ProfitAgreementTemplateLog current = agreementTemplateLogService.create(templateLog);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 日志分页条件查询
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "日志分页条件查询")
  @GetMapping("/findByConditions")
  public Result<Page<ProfitAgreementTemplateLog>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                        @ApiParam(name = "dto", value = "日志信息分页条件查询dto") ProfitAgreementTemplateLogDto dto) {
    try {
      Page<ProfitAgreementTemplateLog> page = this.agreementTemplateLogService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
