package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 分利协议实体对象
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Agreement", description = "分利协议实体对象")
@TableName("agreement")
public class Agreement extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -3536109320556712746L;

  /**
   * 协议编码
   *   @Column(name = "agreement_code",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 协议编码 '")
   */
  @ApiModelProperty("协议编码")
  @TableField(value = "agreement_code")
  private String agreementCode;

  /**
   * 协议名称
   *   @Column(name = "agreement_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 协议名称 '")
   */
  @ApiModelProperty("协议名称")
  @TableField(value = "agreement_name")
  private String agreementName;

  /**
   * 所属协议模板编码
   */
  @ApiModelProperty("所属协议模板编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 所属协议模板
   *   @Column(name = "belong_template",nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 所属协议模板 '")
   */
  @ApiModelProperty("所属协议模板")
  @TableField(value = "belong_template")
  private String belongTemplate;

  /**
   * 关联终端编码
   */
  @ApiModelProperty("关联终端编码")
  @TableField(value = "terminal_code")
  private String terminalCode;

  /**
   * 关联终端
   */
  @ApiModelProperty("关联终端")
  @TableField(value = "relation_terminal")
  private String relationTerminal;

  /**
   * 关联经销商编码
   */
  @ApiModelProperty("关联经销商编码")
  @TableField(value = "customer_code")
  private String customerCode;

  /**
   * 关联经销商
   *   @Column(name = "relation_dealer",nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 关联经销商 '")
   */
  @ApiModelProperty("关联经销商")
  @TableField(value = "relation_dealer")
  private String relationDealer;


  /**
   * 协议状态
   *   @Column(name = "agreement_status",nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 协议状态 '")
   */
  @ApiModelProperty("协议状态")
  @TableField(value = "agreement_status")
  private String agreementStatus;

  /**
   * 签署状态
   *   @Column(name = "sign_status",nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 签署状态 '")
   */
  @ApiModelProperty("签署状态")
  @TableField(value = "sign_status")
  private String signStatus;

  /**
   * 模板信息
   */
  @ApiModelProperty("模板信息")
  @TableField(exist = false)
  private ProfitAgreementTemplate profitAgreementTemplate;

  /**
   * 协议签署
   */
  @ApiModelProperty("协议签署")
  @TableField(exist = false)
  private Set<AgreementSign> agreementSigns;

  /**
   * 终端签署状态
   */
  @ApiModelProperty("终端签署状态")
  @TableField(value = "terminal_sign_status")
  private String terminalSignStatus;

  /**
   * 经销商签署状态
   */
  @ApiModelProperty("经销商签署状态")
  @TableField(value = "dealer_sign_status")
  private String dealerSignStatus;


}
