package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 协议签署实体
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AgreementSign", description = "协议签署实体")
@TableName("agreement_sign")
public class AgreementSign extends TenantOpEntity {
  private static final long serialVersionUID = 6195824434854223529L;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  @TableField(value = "agreement_code")
  private String agreementCode;

  /**
   * 签署时间
   */
  @ApiModelProperty("签署时间")
  @TableField(value = "sign_date")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  private Date signDate;

  /**
   * 签名照片文件名
   */
  @ApiModelProperty("签名照片文件名")
  @TableField(value = "signature_filename")
  private String signatureFilename;

  /**
   * 签名照片文件夹
   */
  @ApiModelProperty("签名照片文件夹")
  @TableField(value = "signature_path")
  private String signaturePath;

  /**
   * 签署方
   */
  @ApiModelProperty("签署方")
  @TableField(value = "signatory")
  private String signatory;

  /**
   * 签署方名称
   */
  @ApiModelProperty("签署方名称")
  @TableField(value = "signatory_name")
  private String signatoryName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @TableField(value = "signatory_code")
  private String signatoryCode;

  /**
   * 签署人
   */
  @ApiModelProperty("签署人")
  @TableField(value = "sign_account")
  private String signAccount;


  /**
   * 协议
   */
  @ApiModelProperty("协议")
  @TableField(exist = false)
  private Agreement agreement;

}
