package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.Set;

/**
 * @author jerry7
 * @date 2021-07-21
 * 分离协议模板实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProfitAgreementTemplate", description = "分利协议模板")
@TableName("profit_agreement_template")
public class ProfitAgreementTemplate extends TenantFlagOpEntity {
  private static final long serialVersionUID = 4152275804637321581L;

  /**
   * 模板编码
   */
  @Column(name = "template_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 模板编码 '")
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 模板名称
   */
  @Column(name = "template_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 模板名称 '")
  @ApiModelProperty("模板名称")
  @TableField(value = "template_name")
  private String templateName;

  /**
   * 协议生效开始日期
   */
  @Column(name = "effective_start_time", nullable = false, columnDefinition = "datetime COMMENT ' 协议生效开始时间 '")
  @ApiModelProperty("协议生效开始日期")
  @TableField(value = "effective_start_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date effectiveStartTime;

  /**
   * 协议生效结束日期
   */
  @Column(name = "effective_end_time", nullable = false, columnDefinition = "datetime COMMENT ' 协议生效结束时间 '")
  @ApiModelProperty("协议生效结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @TableField(value = "effective_end_time")
  private Date effectiveEndTime;

  /**
   * 协议签署开始日期
   */
  @Column(name = "sign_start_time", nullable = false, columnDefinition = "datetime COMMENT ' 协议签署开始时间 '")
  @ApiModelProperty("协议签署开始日期")
  @TableField(value = "sign_start_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signStartTime;

  /**
   * 协议签署结束日期
   */
  @Column(name = "sign_end_time", nullable = false, columnDefinition = "datetime COMMENT ' 协议签署结束时间 '")
  @ApiModelProperty("协议签署结束日期")
  @TableField(value = "sign_end_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signEndTime;

  /**
   * 已生成协议数量
   */
  @Column(name = "generated_agreement_number", nullable = false, columnDefinition = "INT(11) COMMENT ' 已生成协议数量 '")
  @ApiModelProperty("已生成协议数量")
  @TableField(value = "generated_agreement_number")
  private Integer generatedAgreementNumber;

  /**
   * 协议文本
   */
  @Column(name = "agreement_text", nullable = false, columnDefinition = "text COMMENT ' 协议文本 '")
  @ApiModelProperty("协议文本")
  @TableField(value = "agreement_text")
  private String agreementText;

  /**
   * 是否自动签署（Y/N） 默认为N
   */
  @Column(name = "auto_sign", nullable = false, length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 是否自动签署（Y/N） '")
  @ApiModelProperty("自动签署(Y/N)")
  @TableField(value = "auto_sign")
  private String autoSign;

  /**
   * 协议模板关联所属组织列表
   */
  @ApiModelProperty("所属组织列表")
  @TableField(exist = false)
  private Set<TemplateOrgRelationship> templateOrgRelationships;

  /**
   * 协议模板包含政策列表
   */
  @ApiModelProperty("包含政策列表")
  @TableField(exist = false)
  private Set<TemplatePolicyRelationship> templatePolicyRelationships;


  /**
   * 协议模板包含标签
   */
  @ApiModelProperty("包含标签列表")
  @TableField(exist = false)
  private Set<TemplateTag> templateTags;

  /**
   * 协议模板包含渠道
   */
  @ApiModelProperty("包含渠道列表")
  @TableField(exist = false)
  private Set<TemplateChannelRelationship> templateChannelRelationships;

  /**
   * 权限类型
   */
  @ApiModelProperty("权限类型：0全部终端门店，1部分终端门店，2指定终端门店")
  @TableField("permission_type")
  private Integer permissionType;

  /**
   * 指定终端门店编码集合
   */
  @ApiModelProperty("指定终端门店编码集合")
  @TableField(exist = false)
  private Set<TemplateTerminalRelationship> templateTerminalRelationships;
}
