package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 分利协议模板日志明细
 * @Author: zengxingwang
 * @Date: 2021/11/19 11:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProfitAgreementTemplateDetailLog", description = "分利协议模板日志明细")
@TableName("profit_agreement_template_detail_log")
public class ProfitAgreementTemplateDetailLog extends UuidEntity {

  /**
   * 分利协议模板日志id
   */
  @Column(name = "agreement_template_log_id",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分利协议模板日志id '")
  @ApiModelProperty("分利协议模板日志id")
  @TableField(value = "agreement_template_log_id")
  private String agreementTemplateLogId;

  /**
   * 字段名称
   */
  @Column(name = "field_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 字段名称 '")
  @ApiModelProperty("字段名称")
  @TableField(value = "field_name")
  private String fieldName;

  /**
   * 原始值
   */
  @ApiModelProperty("原始值")
  @TableField(value = "original_value")
  private String originalValue;

  /**
   * 最新值
   */
  @ApiModelProperty("最新值")
  @TableField(value = "new_value")
  private String newValue;
}
