package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.Set;

/**
 * @author jerry7
 * @date 2021-07-21
 * 分利协议模板日志
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProfitAgreementTemplateLog", description = "分利协议模板日志")
@TableName("profit_agreement_template_log")
public class ProfitAgreementTemplateLog extends TenantOpEntity {

  /**
   * 模板编码
   */
  @Column(name = "template_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 模板编码 '")
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 模板名称
   */
  @Column(name = "template_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 模板名称 '")
  @ApiModelProperty("模板名称")
  @TableField(value = "template_name")
  private String templateName;

  /**
   * 日志编码
   */
  @Column(name = "log_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 日志编码 '")
  @ApiModelProperty("日志编码")
  @TableField(value = "log_code")
  private String logCode;

  /**
   * 操作类型
   */
  @Column(name = "operate_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 操作类型 '")
  @ApiModelProperty("操作类型")
  @TableField(value = "operate_type")
  private String operateType;

  /**
   * 日志明细
   */
  @ApiModelProperty("日志明细")
  @TableField(exist = false)
  private Set<ProfitAgreementTemplateDetailLog> agreementTemplateDetailLogs;
}
