package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author jerry7
 * @date 2021-07-23
 * 协议模板与渠道关联实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TemplateChannelRelationship", description = "协议模板与渠道关联表")
@TableName("template_channel_relationship")
public class TemplateChannelRelationship extends BaseIdEntity {
  private static final long serialVersionUID = -6177464611562548443L;

  /**
   * 分利协议模板编码
   */
  @Column(name = "template_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 模板编码 '")
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 所属组织编码
   */
  @Column(name = "channel_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属渠道编码 '")
  @ApiModelProperty("所属组织编码")
  @TableField(value = "channel_code")
  private String channelCode;

  /**
   * 所属组织名称
   */
  @Column(name = "channel_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属渠道名称 '")
  @ApiModelProperty("所属组织名称")
  @TableField(value = "channel_name")
  private String channelName;
}
