package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author jerry7
 * @date 2021-07-21
 * 协议模板与组织关联实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TemplateOrgRelationship", description = "协议模板与组织关联表")
@TableName("template_org_relationship")
public class TemplateOrgRelationship extends BaseIdEntity {
  private static final long serialVersionUID = 2398248965094366388L;

  /**
   * 分利协议模板编码
   */
  @Column(name = "template_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 模板编码 '")
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 所属组织编码
   */
  @Column(name = "org_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @Column(name = "org_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织名称 '")
  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  private String orgName;
}
