package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author jerry7
 * @date 2021-07-21
 * 协议模板与政策关联实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TemplatePolicyRelationship", description = "协议模板与政策关联表")
@TableName("template_policy_relationship")
public class TemplatePolicyRelationship extends BaseIdEntity {
  private static final long serialVersionUID = -5460953357376847272L;

  /**
   * 分利协议模板编码
   */
  @Column(name = "template_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 模板编码 '")
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 分利政策编码
   */
  @Column(name = "policy_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分利政策编码 '")
  @ApiModelProperty("分利政策编码")
  @TableField(value = "policy_code")
  private String policyCode;

  /**
   * 分利政策名称
   */
  @Column(name = "policy_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分利政策名称 '")
  @ApiModelProperty("分利政策名称")
  @TableField(value = "policy_name")
  private String policyName;
}
