package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author jerry7
 * @date 2021-07-21
 * 协议模板关联标签实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TemplateTagRelationship", description = "协议模板标签关联表")
@TableName("template_tag_relationship")
public class TemplateTag extends BaseIdEntity {
  private static final long serialVersionUID = 3215263300714554548L;

  /**
   * 分利协议模板编码
   */
  @Column(name = "template_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 模板编码 '")
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 标签
   */
  @Column(name = "tag",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分利模板包含标签 '")
  @ApiModelProperty("标签")
  @TableField(value = "tag")
  private String tag;
}
