package com.biz.crm.cps.business.agreement.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 协议模板与指定终端关联表
 * @Author: zengxingwang
 * @Date: 2021/11/19 10:11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TemplateTerminalRelationship", description = "协议模板与指定终端关联表")
@TableName("template_terminal_relationship")
public class TemplateTerminalRelationship extends UuidEntity {

  /**
   * 分利协议模板编码
   */
  @Column(name = "template_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 模板编码 '")
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 指定终端编码
   */
  @Column(name = "terminal_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 指定终端编码 '")
  @ApiModelProperty("指定终端编码")
  @TableField(value = "terminal_code")
  private String terminalCode;
}
