package com.biz.crm.cps.business.agreement.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * Agreement 的 mybatis 操作接口
 * @author songjingen
 */
public interface AgreementMapper extends BaseMapper<Agreement> {

  /**
   * 分页条件查询
   * @param page
   * @param dto
   * @return
   */
  Page<Agreement> findByConditions(@Param("page") Page<Agreement> page, @Param("dto") AgreementDto dto);

  /**
   * 查看详情，包含签署情况
   * @param id
   * @return
   */
  Agreement findDetailsById(@Param("id") String id);

  /**
   * 根据登录信息查询出协议实例集合
   * @param dto
   * @return
   */
  List<Agreement> findByLoginUserAgreementDto(@Param("dto") LoginUserAgreementDto dto);

  /**
   * 查询协议协议生效开始时间小于等于当前时间，且协议状态未开始；
   * 查询协议协议生效结束时间小于当前时间，且协议状态进行中
   * @param date
   * @return
   */
  List<Agreement> findByCurrentTime(@Param("date") Date date);

  /**
   * 查询数据不带分页
   * @param dto
   * @return
   */
  List<Agreement> findByConditions(@Param("dto") AgreementDto dto);
}
